/*
 * Decompiled with CFR 0.152.
 */
package me.angel.tridentrain.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import me.angel.tridentrain.CustomTridentEntity;
import me.angel.tridentrain.RainType;
import me.angel.tridentrain.Tridentrain;
import me.angel.tridentrain.config.TridentRainConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ChallengingRainCommand {
    private static final SuggestionProvider<class_2168> ENTITY_TYPE_SUGGESTIONS = (context, builder) -> ChallengingRainCommand.suggestEntityTypes(builder);

    private static CompletableFuture<Suggestions> suggestEntityTypes(SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        class_7923.field_41177.method_10235().stream().filter(id -> id.method_12836().equals("minecraft")).map(class_2960::method_12832).filter(path -> path.toLowerCase().contains(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        class_7923.field_41177.method_10235().stream().filter(id -> !id.method_12836().equals("minecraft")).map(class_2960::toString).filter(name -> name.toLowerCase().contains(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rain").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"toggle").executes(context -> {
            boolean isActive = Tridentrain.toggleTridentRain();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Rain " + (isActive ? "enabled" : "disabled"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockbreaking").then(class_2170.method_9247((String)"toggle").executes(context -> {
            boolean isEnabled = Tridentrain.toggleBlockBreaking();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Block breaking " + (isEnabled ? "enabled" : "disabled"))), true);
            return 1;
        }))).then(class_2170.method_9247((String)"on").executes(context -> {
            Tridentrain.setBlockBreaking(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Block breaking enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(context -> {
            Tridentrain.setBlockBreaking(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Block breaking disabled"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"type").then(class_2170.method_9247((String)"trident").executes(context -> {
            Tridentrain.setRainType(RainType.TRIDENT);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Rain type set to Trident"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"anvil").executes(context -> {
            Tridentrain.setRainType(RainType.ANVIL);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Rain type set to Anvil"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"entity").executes(context -> {
            Tridentrain.setRainType(RainType.ENTITY);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Rain type set to Entity (" + Tridentrain.getEntityType() + ")")), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7c\u26a0 WARNING: Entity rain is highly experimental! Use at your own risk as it might not work properly with every entity type."), false);
            return 1;
        }))).then(class_2170.method_9247((String)"potion").executes(context -> {
            Tridentrain.setRainType(RainType.POTION);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Rain type set to Potion"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"tnt").executes(context -> {
            Tridentrain.setRainType(RainType.TNT);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Rain type set to TNT"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setentity").then(class_2170.method_9244((String)"entityType", (ArgumentType)StringArgumentType.string()).suggests(ENTITY_TYPE_SUGGESTIONS).executes(context -> {
            String entityType = StringArgumentType.getString((CommandContext)context, (String)"entityType");
            Tridentrain.setEntityType(entityType);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Entity type set to " + entityType)), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7c\u26a0 WARNING: Entity rain is highly experimental! Use at your own risk as it might not work properly with every entity type."), false);
            return 1;
        }))).executes(context -> {
            String currentEntityType = Tridentrain.getEntityType();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76Entity Rain Usage:\u00a7r\n- \u00a7e/rain setentity <entity>\u00a7r: Set entity type (e.g. zombie, skeleton, creeper)\n- \u00a7e/rain type entity\u00a7r: Change rain type to entity rain\n\nCurrent entity type: \u00a7e" + currentEntityType + "\u00a7r")), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"explosiveAnvils").then(class_2170.method_9247((String)"toggle").executes(context -> {
            boolean isEnabled = Tridentrain.toggleExplosiveAnvils();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Explosive anvils " + (isEnabled ? "enabled" : "disabled"))), true);
            return 1;
        }))).then(class_2170.method_9247((String)"on").executes(context -> {
            Tridentrain.setExplosiveAnvils(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Explosive anvils enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(context -> {
            Tridentrain.setExplosiveAnvils(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Explosive anvils disabled"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"anvilDiscarding").then(class_2170.method_9247((String)"toggle").executes(context -> {
            boolean isEnabled = Tridentrain.toggleAnvilDiscarding();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Anvil discarding " + (isEnabled ? "enabled" : "disabled"))), true);
            return 1;
        }))).then(class_2170.method_9247((String)"on").executes(context -> {
            Tridentrain.setAnvilDiscarding(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Anvil discarding enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(context -> {
            Tridentrain.setAnvilDiscarding(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Anvil discarding disabled"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"explosivechance").then(class_2170.method_9244((String)"chance", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(context -> {
            double inputChance = DoubleArgumentType.getDouble((CommandContext)context, (String)"chance");
            float chance = (float)(inputChance / 100.0);
            Tridentrain.setExplosionChance(chance);
            String chanceDisplay = inputChance < 1.0 ? String.format("%.2f", inputChance) : String.format("%.0f", inputChance);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Explosion chance set to " + chanceDisplay + "%")), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setExplosionChance(0.05f);
            float defaultPercentage = 5.0f;
            String chanceDisplay = defaultPercentage < 1.0f ? String.format("%.2f", Float.valueOf(defaultPercentage)) : String.format("%.0f", Float.valueOf(defaultPercentage));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Explosion chance reset to default (" + chanceDisplay + "%)")), true);
            return 1;
        }))).executes(context -> {
            float currentChance = Tridentrain.getExplosionChance() * 100.0f;
            String chanceDisplay = currentChance < 1.0f ? String.format("%.2f", Float.valueOf(currentChance)) : String.format("%.0f", Float.valueOf(currentChance));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76Explosion Chance Usage:\u00a7r\n- \u00a7e/rain explosivechance <0-100>\u00a7r: Set chance (e.g. 0.50 for 0.5%, 5 for 5%, 100 for 100%)\n- \u00a7e/rain explosivechance default\u00a7r: Reset to default\n\nCurrent chance: \u00a7e" + chanceDisplay + "%")), false);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.resetToDefaults();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Settings reset to defaults"), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"intensity").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(context -> {
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            Tridentrain.setIntensity(level);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Rain intensity set to level " + level)), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setIntensity(1);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Rain intensity reset to default (level 1)"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"height").then(class_2170.method_9244((String)"blocks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int height = IntegerArgumentType.getInteger((CommandContext)context, (String)"blocks");
            Tridentrain.setFallHeight(height);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Fall height set to " + height + " blocks")), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setFallHeight(50);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Fall height reset to default (50 blocks)"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"blocks", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0)).executes(context -> {
            double radius = DoubleArgumentType.getDouble((CommandContext)context, (String)"blocks");
            Tridentrain.setSpawnRadius(radius);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Spawn radius set to " + radius + " blocks")), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setSpawnRadius(25.0);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Spawn radius reset to default (25.0 blocks)"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"minangle").then(class_2170.method_9244((String)"degrees", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)90.0)).executes(context -> {
            double angle = DoubleArgumentType.getDouble((CommandContext)context, (String)"degrees");
            Tridentrain.setMinAngle(angle);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Minimum angle set to " + angle + " degrees")), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setMinAngle(1.0);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Minimum angle reset to default (1.0 degrees)"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxangle").then(class_2170.method_9244((String)"degrees", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)90.0)).executes(context -> {
            double angle = DoubleArgumentType.getDouble((CommandContext)context, (String)"degrees");
            Tridentrain.setMaxAngle(angle);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Maximum angle set to " + angle + " degrees")), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setMaxAngle(15.0);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Maximum angle reset to default (15.0 degrees)"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"potionamplifier").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)5)).executes(context -> {
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            Tridentrain.setMaxPotionAmplifier(level);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Maximum potion amplifier set to " + level)), true);
            return 1;
        }))).then(class_2170.method_9247((String)"default").executes(context -> {
            Tridentrain.setMaxPotionAmplifier(2);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Maximum potion amplifier reset to default (2)"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tntvariants").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"normal").then(class_2170.method_9247((String)"enable").executes(context -> {
            Tridentrain.setNormalTntEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Normal TNT enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            Tridentrain.setNormalTntEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cNormal TNT disabled"), true);
            return 1;
        }))).executes(context -> {
            boolean enabled = Tridentrain.isNormalTntEnabled();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Normal TNT is " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dud").then(class_2170.method_9247((String)"enable").executes(context -> {
            Tridentrain.setDudTntEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Dud TNT enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            Tridentrain.setDudTntEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cDud TNT disabled"), true);
            return 1;
        }))).executes(context -> {
            boolean enabled = Tridentrain.isDudTntEnabled();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Dud TNT is " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"placed").then(class_2170.method_9247((String)"enable").executes(context -> {
            Tridentrain.setPlacedTntEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Placed TNT enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            Tridentrain.setPlacedTntEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cPlaced TNT disabled"), true);
            return 1;
        }))).executes(context -> {
            boolean enabled = Tridentrain.isPlacedTntEnabled();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Placed TNT is " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delayed").then(class_2170.method_9247((String)"enable").executes(context -> {
            Tridentrain.setDelayedTntEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Delayed TNT enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            Tridentrain.setDelayedTntEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cDelayed TNT disabled"), true);
            return 1;
        }))).executes(context -> {
            boolean enabled = Tridentrain.isDelayedTntEnabled();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Delayed TNT is " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delayeddud").then(class_2170.method_9247((String)"enable").executes(context -> {
            Tridentrain.setDelayedDudTntEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Delayed Dud TNT enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            Tridentrain.setDelayedDudTntEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cDelayed Dud TNT disabled"), true);
            return 1;
        }))).executes(context -> {
            boolean enabled = Tridentrain.isDelayedDudTntEnabled();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Delayed Dud TNT is " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled"))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"healing").then(class_2170.method_9247((String)"enable").executes(context -> {
            Tridentrain.setHealingTntEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Healing TNT enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            Tridentrain.setHealingTntEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cHealing TNT disabled"), true);
            return 1;
        }))).executes(context -> {
            boolean enabled = Tridentrain.isHealingTntEnabled();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Healing TNT is " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled"))), true);
            return 1;
        }))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76TNT Variants Usage:\u00a7r\n- \u00a7e/rain tntvariants normal [enable/disable]\u00a7r: Toggle normal TNT (most common)\n- \u00a7e/rain tntvariants dud [enable/disable]\u00a7r: Toggle dud TNT (no damage)\n- \u00a7e/rain tntvariants placed [enable/disable]\u00a7r: Toggle placed TNT (becomes block)\n- \u00a7e/rain tntvariants delayed [enable/disable]\u00a7r: Toggle delayed TNT (long fuse)\n- \u00a7e/rain tntvariants delayeddud [enable/disable]\u00a7r: Toggle delayed dud TNT (long fuse, no damage)\n- \u00a7e/rain tntvariants healing [enable/disable]\u00a7r: Toggle healing TNT (heals players)\n\nCurrent status:\n- Normal TNT: " + (Tridentrain.isNormalTntEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a7r (80% chance)\n- Dud TNT: " + (Tridentrain.isDudTntEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a7r (4% chance)\n- Placed TNT: " + (Tridentrain.isPlacedTntEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a7r (4% chance)\n- Delayed TNT: " + (Tridentrain.isDelayedTntEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a7r (4% chance)\n- Delayed Dud TNT: " + (Tridentrain.isDelayedDudTntEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a7r (4% chance)\n- Healing TNT: " + (Tridentrain.isHealingTntEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a7r (4% chance)")), false);
            return 1;
        }))).then(class_2170.method_9247((String)"status").executes(context -> {
            String spawnRateInfo;
            Object rainTypeInfo;
            TridentRainConfig config = Tridentrain.getConfig();
            if (config.getCurrentRainType() == RainType.ENTITY) {
                rainTypeInfo = config.getCurrentRainType().getDisplayName() + " (" + config.getEntityType() + ")";
            } else if (config.getCurrentRainType() == RainType.TNT) {
                StringBuilder tntInfo = new StringBuilder(config.getCurrentRainType().getDisplayName() + " (");
                boolean hasEnabled = false;
                if (Tridentrain.isNormalTntEnabled()) {
                    tntInfo.append("Normal");
                    hasEnabled = true;
                }
                if (Tridentrain.isDudTntEnabled()) {
                    if (hasEnabled) {
                        tntInfo.append(", ");
                    }
                    tntInfo.append("Dud");
                    hasEnabled = true;
                }
                if (Tridentrain.isPlacedTntEnabled()) {
                    if (hasEnabled) {
                        tntInfo.append(", ");
                    }
                    tntInfo.append("Placed");
                    hasEnabled = true;
                }
                if (Tridentrain.isDelayedTntEnabled()) {
                    if (hasEnabled) {
                        tntInfo.append(", ");
                    }
                    tntInfo.append("Delayed");
                    hasEnabled = true;
                }
                if (Tridentrain.isDelayedDudTntEnabled()) {
                    if (hasEnabled) {
                        tntInfo.append(", ");
                    }
                    tntInfo.append("DelayedDud");
                    hasEnabled = true;
                }
                if (Tridentrain.isHealingTntEnabled()) {
                    if (hasEnabled) {
                        tntInfo.append(", ");
                    }
                    tntInfo.append("Healing");
                    hasEnabled = true;
                }
                if (!hasEnabled) {
                    tntInfo.append("None enabled");
                }
                tntInfo.append(")");
                rainTypeInfo = tntInfo.toString();
            } else {
                rainTypeInfo = config.getCurrentRainType().getDisplayName();
            }
            if (config.getCurrentRainType() == RainType.TNT) {
                int tntFrequency = ChallengingRainCommand.getTntSpawnFrequency(config);
                int intensityLevel = config.getCurrentIntensityLevel();
                String probability = intensityLevel <= 3 ? "50% chance" : (intensityLevel <= 6 ? "70% chance" : "80% chance");
                spawnRateInfo = String.format("\u00a7e1\u00a7r every \u00a7e%.1f\u00a7r seconds (%s) (TNT-specific)", (double)tntFrequency / 20.0, probability);
            } else {
                spawnRateInfo = String.format("\u00a7e%d\u00a7r", config.getTridentsPerTick());
            }
            ((class_2168)context.getSource()).method_9226(() -> ChallengingRainCommand.lambda$register$112((String)rainTypeInfo, config, spawnRateInfo), false);
            return 1;
        }))).then(class_2170.method_9247((String)"protectedblocks").executes(context -> {
            StringBuilder blockList = new StringBuilder("Protected Blocks:\n");
            blockList.append("Note: Bedrock can be broken in the Nether\n\n");
            CustomTridentEntity.BLOCK_FILTER.stream().map(block -> block.method_9518().getString()).sorted().forEach(name -> blockList.append("- ").append((String)name).append("\n"));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)blockList.toString()), false);
            return 1;
        }))).then(class_2170.method_9247((String)"strongblocks").executes(context -> {
            StringBuilder blockList = new StringBuilder("\u00a76Strong Blocks:\u00a7r\n");
            blockList.append("\u00a77These blocks will be broken but will stop tridents\u00a7r\n\n");
            CustomTridentEntity.STRONG_BLOCKS.stream().map(block -> block.method_9518().getString()).sorted().forEach(name -> blockList.append("- \u00a7e").append((String)name).append("\u00a7r\n"));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)blockList.toString()), false);
            return 1;
        })));
    }

    private static int getTntSpawnFrequency(TridentRainConfig config) {
        int intensityLevel = config.getCurrentIntensityLevel();
        if (intensityLevel <= 3) {
            return 30;
        }
        if (intensityLevel <= 6) {
            return 20;
        }
        return 15;
    }

    private static /* synthetic */ class_2561 lambda$register$112(String rainTypeInfo, TridentRainConfig config, String spawnRateInfo) {
        return class_2561.method_43470((String)String.format("\u00a76Challenging Rain Status:\u00a7r\n\u00a77Basic Settings:\u00a7r\n- Active: \u00a7e%s\u00a7r\n- Rain Type: \u00a7e%s\u00a7r\n- Block Breaking: \u00a7e%s\u00a7r\n- Intensity Level: \u00a7e%d\u00a7r\n- Explosive Anvils: \u00a7e%s\u00a7r\n- Explosion Chance: \u00a7e%.2f%%\u00a7r\n- Anvil Discarding: \u00a7e%s\u00a7r\n- Max Potion Amplifier: \u00a7e%d\u00a7r\n\n\u00a77Spawn Settings:\u00a7r\n- Items per Tick: %s\n- Height: \u00a7e%d\u00a7r blocks\n- Radius: \u00a7e%.1f\u00a7r blocks\n\n\u00a77Angle Settings:\u00a7r\n- Range: \u00a7e%.1f\u00b0\u00a7r to \u00a7e%.1f\u00b0\u00a7r", Tridentrain.isActive() ? "Yes" : "No", rainTypeInfo, Tridentrain.isBlockBreakingEnabled() ? "Enabled" : "Disabled", config.getCurrentIntensityLevel(), Tridentrain.isExplosiveAnvilsEnabled() ? "Enabled" : "Disabled", Float.valueOf(config.getExplosionChance() * 100.0f), Tridentrain.isAnvilDiscardingEnabled() ? "Enabled" : "Disabled", config.getMaxPotionAmplifier(), spawnRateInfo, config.getFallHeight(), config.getSpawnRadius(), config.getMinAngle(), config.getMaxAngle()));
    }
}

